<?xml version="1.0"?>
<!--
 Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 

   NAME
     rspfmt_raw2ext_transformer_v11_2_0_1.xsl - XSLT to transform internal database response file format to external property file format

   DESCRIPTION
     <short description of component this file declares/defines>

   NOTES
     <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    davjimen    04/24/12 - Update choices consistency, all bullets
    pkuruvad    03/01/12 - Bug 13584766 changes
    davjimen    06/01/11 - XbranchMerge davjimen_bug-12582060 from
                           st_install_11.2.0
    pvallam     05/19/11 - removing cluster_nodes
    pvallam     05/13/11 - adding proxy realm
    huliliu     05/11/11 - XbranchMerge huliliu_lrg-5554351 from main
    huliliu     05/10/11 - add the responsFile version issue to the rsp file so
                           that it can pass the xsd validation
    pvallam     07/22/10 - modifying the comments of download location
    pvallam     06/02/10 - updating the autoupdates option
    sangkuma    03/04/09 - Retaining the names of OUI session variables
    aqazi       07/02/08 - remove ORACLE_HOME_NAME
    sangkuma    03/12/08 - change the property name of
                           oracle.install.OPERGroupNameUsed to
                           UNIX_GROUP_NAME
    dschrein    01/12/08 - creation
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" indent="false"></xsl:output>
<xsl:template match="beanstore">

###############################################################################
## Copyright(c) Oracle Corporation 1998,2013. All rights reserved.           ##
##                                                                           ##
## Specify values for the variables listed below to customize                ##
## your installation.                                                        ##
##                                                                           ##
## Each variable is associated with a comment. The comment                   ##
## can help to populate the variables with the appropriate                   ##
## values.                                                                   ##
##                                                                           ##
###############################################################################

#-------------------------------------------------------------------------------
# Do not change the following system generated value.
#-------------------------------------------------------------------------------
oracle.install.responseFileVersion=/oracle/install/rspfmt_demosinstall_response_schema_v12.1.0

#-------------------------------------------------------------------------------
# This variable holds the hostname of the system as set by the user. 
# It can be used to force the installation to use an alternative   
# hostname rather than using the first hostname found on the system
# (e.g., for systems with multiple hostnames and network interfaces).
#-------------------------------------------------------------------------------
ORACLE_HOSTNAME=<xsl:value-of select="DemosSetupBean/ORACLE_HOSTNAME"/>

#-------------------------------------------------------------------------------
# Unix group to be set for the inventory directory.  
#-------------------------------------------------------------------------------
UNIX_GROUP_NAME=<xsl:value-of select="DemosSetupBean/CentralInventorySettings/UNIX_GROUP_NAME"/>

#-------------------------------------------------------------------------------
# Inventory location.
#-------------------------------------------------------------------------------
INVENTORY_LOCATION=<xsl:value-of select="DemosSetupBean/CentralInventorySettings/INVENTORY_LOCATION"/>

#-------------------------------------------------------------------------------
# Languages in which the components will be installed.             
# 
# en   : English                  ja   : Japanese                  
# fr   : French                   ko   : Korean                    
# ar   : Arabic                   es   : Latin American Spanish    
# bn   : Bengali                  lv   : Latvian                   
# pt_BR: Brazilian Portuguese     lt   : Lithuanian                
# bg   : Bulgarian                ms   : Malay                     
# fr_CA: Canadian French          es_MX: Mexican Spanish           
# ca   : Catalan                  no   : Norwegian                 
# hr   : Croatian                 pl   : Polish                    
# cs   : Czech                    pt   : Portuguese                
# da   : Danish                   ro   : Romanian                  
# nl   : Dutch                    ru   : Russian                   
# ar_EG: Egyptian                 zh_CN: Simplified Chinese        
# en_GB: English (Great Britain)  sk   : Slovak                    
# et   : Estonian                 sl   : Slovenian                 
# fi   : Finnish                  es_ES: Spanish                   
# de   : German                   sv   : Swedish                   
# el   : Greek                    th   : Thai                      
# iw   : Hebrew                   zh_TW: Traditional Chinese       
# hu   : Hungarian                tr   : Turkish                   
# is   : Icelandic                uk   : Ukrainian                 
# in   : Indonesian               vi   : Vietnamese                
# it   : Italian                                                   
#
# all_langs   : All languages
#
# Specify value as the following to select any of the languages.
# Example : SELECTED_LANGUAGES=en,fr,ja
#
# Specify value as the following to select all the languages.
# Example : SELECTED_LANGUAGES=all_langs  
#-------------------------------------------------------------------------------
SELECTED_LANGUAGES=<xsl:call-template name="toStringList"><xsl:with-param name="valueList" select="DemosSetupBean/SELECTED_LANGUAGES"/></xsl:call-template>

#-------------------------------------------------------------------------------
# Complete path of the Oracle Home 
#------------------------------------------------------------------------------- 
ORACLE_HOME=<xsl:value-of select="DemosSetupBean/DemosInstallSettings/ORACLE_HOME"/>

#-------------------------------------------------------------------------------
# Complete path of the Oracle Base. 
#-------------------------------------------------------------------------------
ORACLE_BASE=<xsl:value-of select="DemosSetupBean/DemosInstallSettings/ORACLE_BASE"/>

#------------------------------------------------------------------------------
# Specify the auto-updates option. It can be one of the following:
#   - MYORACLESUPPORT_DOWNLOAD
#   - OFFLINE_UPDATES
#   - SKIP_UPDATES
#------------------------------------------------------------------------------
oracle.installer.autoupdates.option=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_option"/>

#------------------------------------------------------------------------------
# In case MYORACLESUPPORT_DOWNLOAD option is chosen, specify the location where
# the updates are to be downloaded.
# In case OFFLINE_UPDATES option is chosen, specify the location where the updates 
# are present.
#------------------------------------------------------------------------------
oracle.installer.autoupdates.downloadUpdatesLoc=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_downloadLoc" />

#------------------------------------------------------------------------------
# Specify the My Oracle Support Account Username which has the patches download privileges  
# to be used for software updates.
#  Example   : AUTOUPDATES_MYORACLESUPPORT_USERNAME=abc@oracle.com
#------------------------------------------------------------------------------
AUTOUPDATES_MYORACLESUPPORT_USERNAME=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_myOracleSupportCredentials/oracle_install_autoupdates_myOracleSupportUserName"/>

#------------------------------------------------------------------------------
# Specify the My Oracle Support Account Username password which has the patches download privileges  
# to be used for software updates.
#
# Example    : AUTOUPDATES_MYORACLESUPPORT_PASSWORD=password
#------------------------------------------------------------------------------
AUTOUPDATES_MYORACLESUPPORT_PASSWORD=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_myOracleSupportCredentials/oracle_install_autoupdates_myOracleSupportPassword"/>

#------------------------------------------------------------------------------
# Specify the Proxy server name. Length should be greater than zero.
#
# Example    : PROXY_HOST=proxy.domain.com 
#------------------------------------------------------------------------------
PROXY_HOST=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyHost"/>

#------------------------------------------------------------------------------
# Specify the proxy port number. Should be Numeric and atleast 2 chars.
#
# Example    : PROXY_PORT=25 
#------------------------------------------------------------------------------
PROXY_PORT=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyPort"/>

#------------------------------------------------------------------------------
# Specify the proxy user name. Leave PROXY_USER and PROXY_PWD 
# blank if your proxy server requires no authentication.
#
# Example    : PROXY_USER=username 
#------------------------------------------------------------------------------
PROXY_USER=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyUser"/>

#------------------------------------------------------------------------------
# Specify the proxy password. Leave PROXY_USER and PROXY_PWD  
# blank if your proxy server requires no authentication.
#
# Example    : PROXY_PWD=password 
#------------------------------------------------------------------------------
PROXY_PWD=<xsl:value-of select="DemosSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyPassword"/>

#------------------------------------------------------------------------------
# Specify the proxy realm.
#
# Example    : PROXY_REALM=metalink
#------------------------------------------------------------------------------
PROXY_REALM=<xsl:value-of select="DBSetupBean/AutoUpdatesInstallSettings/oracle_install_autoupdates_httpProxySettings/oracle_install_autoupdates_httpProxyRealm"/>
</xsl:template>
<xsl:template name="toStringList">
<xsl:param name="valueList"/>
<xsl:variable name="valueCount" select="count($valueList/value)"/>
<xsl:for-each select="$valueList/value"><xsl:value-of select="."/><xsl:if test="$valueCount > position()">,</xsl:if></xsl:for-each>	
</xsl:template>
</xsl:stylesheet>
